from asdl import pybase

option_t = int  # type alias for integer

class option_i(object):
  errexit = 1
  nounset = 2
  pipefail = 3
  inherit_errexit = 4
  nullglob = 5
  verbose_errexit = 6
  verbose_warn = 7
  noexec = 8
  xtrace = 9
  verbose = 10
  noglob = 11
  noclobber = 12
  errtrace = 13
  posix = 14
  vi = 15
  emacs = 16
  interactive = 17
  hashall = 18
  lastpipe = 19
  failglob = 20
  extglob = 21
  nocasematch = 22
  dotglob = 23
  extdebug = 24
  eval_unsafe_arith = 25
  ignore_flags_not_impl = 26
  ignore_shopt_not_impl = 27
  rewrite_extern = 28
  _allow_command_sub = 29
  _allow_process_sub = 30
  dynamic_scope = 31
  redefine_const = 32
  redefine_source = 33
  _running_trap = 34
  _running_hay = 35
  _no_debug_trap = 36
  _no_err_trap = 37
  strict_parse_equals = 38
  strict_parse_slice = 39
  strict_argv = 40
  strict_arith = 41
  strict_array = 42
  strict_control_flow = 43
  strict_env_binding = 44
  strict_errexit = 45
  strict_nameref = 46
  strict_word_eval = 47
  strict_tilde = 48
  strict_glob = 49
  parse_at = 50
  parse_proc = 51
  parse_func = 52
  parse_brace = 53
  parse_bracket = 54
  parse_equals = 55
  parse_paren = 56
  parse_ysh_string = 57
  parse_triple_quote = 58
  simple_word_eval = 59
  dashglob = 60
  command_sub_errexit = 61
  process_sub_fail = 62
  xtrace_rich = 63
  xtrace_details = 64
  sigpipe_status_ok = 65
  env_obj = 66
  init_ysh_globals = 67
  for_loop_frames = 68
  parse_at_all = 69
  parse_backslash = 70
  parse_backticks = 71
  parse_dollar = 72
  parse_ignored = 73
  parse_sh_arith = 74
  parse_dparen = 75
  parse_dbracket = 76
  parse_bare_word = 77
  parse_word_join = 78
  no_exported = 79
  no_init_globals = 80
  simple_echo = 81
  simple_eval_builtin = 82
  simple_test_builtin = 83
  expand_aliases = 84
  progcomp = 85
  hostcomplete = 86
  histappend = 87
  cmdhist = 88
  assoc_expand_once = 89
  autocd = 90
  cdable_vars = 91
  cdspell = 92
  checkhash = 93
  checkjobs = 94
  checkwinsize = 95
  complete_fullquote = 96
  direxpand = 97
  dirspell = 98
  execfail = 99
  extquote = 100
  force_fignore = 101
  globasciiranges = 102
  globstar = 103
  gnu_errfmt = 104
  histreedit = 105
  histverify = 106
  huponexit = 107
  interactive_comments = 108
  lithist = 109
  localvar_inherit = 110
  localvar_unset = 111
  login_shell = 112
  mailwarn = 113
  no_empty_cmd_completion = 114
  nocaseglob = 115
  progcomp_alias = 116
  promptvars = 117
  restricted_shell = 118
  shift_verbose = 119
  sourcepath = 120
  xpg_echo = 121
  ARRAY_SIZE = 122

_option_str = {
  1: 'errexit',
  2: 'nounset',
  3: 'pipefail',
  4: 'inherit_errexit',
  5: 'nullglob',
  6: 'verbose_errexit',
  7: 'verbose_warn',
  8: 'noexec',
  9: 'xtrace',
  10: 'verbose',
  11: 'noglob',
  12: 'noclobber',
  13: 'errtrace',
  14: 'posix',
  15: 'vi',
  16: 'emacs',
  17: 'interactive',
  18: 'hashall',
  19: 'lastpipe',
  20: 'failglob',
  21: 'extglob',
  22: 'nocasematch',
  23: 'dotglob',
  24: 'extdebug',
  25: 'eval_unsafe_arith',
  26: 'ignore_flags_not_impl',
  27: 'ignore_shopt_not_impl',
  28: 'rewrite_extern',
  29: '_allow_command_sub',
  30: '_allow_process_sub',
  31: 'dynamic_scope',
  32: 'redefine_const',
  33: 'redefine_source',
  34: '_running_trap',
  35: '_running_hay',
  36: '_no_debug_trap',
  37: '_no_err_trap',
  38: 'strict_parse_equals',
  39: 'strict_parse_slice',
  40: 'strict_argv',
  41: 'strict_arith',
  42: 'strict_array',
  43: 'strict_control_flow',
  44: 'strict_env_binding',
  45: 'strict_errexit',
  46: 'strict_nameref',
  47: 'strict_word_eval',
  48: 'strict_tilde',
  49: 'strict_glob',
  50: 'parse_at',
  51: 'parse_proc',
  52: 'parse_func',
  53: 'parse_brace',
  54: 'parse_bracket',
  55: 'parse_equals',
  56: 'parse_paren',
  57: 'parse_ysh_string',
  58: 'parse_triple_quote',
  59: 'simple_word_eval',
  60: 'dashglob',
  61: 'command_sub_errexit',
  62: 'process_sub_fail',
  63: 'xtrace_rich',
  64: 'xtrace_details',
  65: 'sigpipe_status_ok',
  66: 'env_obj',
  67: 'init_ysh_globals',
  68: 'for_loop_frames',
  69: 'parse_at_all',
  70: 'parse_backslash',
  71: 'parse_backticks',
  72: 'parse_dollar',
  73: 'parse_ignored',
  74: 'parse_sh_arith',
  75: 'parse_dparen',
  76: 'parse_dbracket',
  77: 'parse_bare_word',
  78: 'parse_word_join',
  79: 'no_exported',
  80: 'no_init_globals',
  81: 'simple_echo',
  82: 'simple_eval_builtin',
  83: 'simple_test_builtin',
  84: 'expand_aliases',
  85: 'progcomp',
  86: 'hostcomplete',
  87: 'histappend',
  88: 'cmdhist',
  89: 'assoc_expand_once',
  90: 'autocd',
  91: 'cdable_vars',
  92: 'cdspell',
  93: 'checkhash',
  94: 'checkjobs',
  95: 'checkwinsize',
  96: 'complete_fullquote',
  97: 'direxpand',
  98: 'dirspell',
  99: 'execfail',
  100: 'extquote',
  101: 'force_fignore',
  102: 'globasciiranges',
  103: 'globstar',
  104: 'gnu_errfmt',
  105: 'histreedit',
  106: 'histverify',
  107: 'huponexit',
  108: 'interactive_comments',
  109: 'lithist',
  110: 'localvar_inherit',
  111: 'localvar_unset',
  112: 'login_shell',
  113: 'mailwarn',
  114: 'no_empty_cmd_completion',
  115: 'nocaseglob',
  116: 'progcomp_alias',
  117: 'promptvars',
  118: 'restricted_shell',
  119: 'shift_verbose',
  120: 'sourcepath',
  121: 'xpg_echo',
}

def option_str(val, dot=True):
  # type: (option_t, bool) -> str
  v = _option_str[val]
  if dot:
    return "option.%s" % v
  else:
    return v

builtin_t = int  # type alias for integer

class builtin_i(object):
  colon = 1
  dot = 2
  exec_ = 3
  eval = 4
  set = 5
  shift = 6
  times = 7
  trap = 8
  unset = 9
  readonly = 10
  local = 11
  declare = 12
  typeset = 13
  export_ = 14
  true_ = 15
  false_ = 16
  try_ = 17
  assert_ = 18
  break_ = 19
  continue_ = 20
  return_ = 21
  exit = 22
  read = 23
  echo = 24
  printf = 25
  mapfile = 26
  readarray = 27
  cd = 28
  pushd = 29
  popd = 30
  dirs = 31
  pwd = 32
  source = 33
  umask = 34
  ulimit = 35
  wait = 36
  jobs = 37
  fg = 38
  bg = 39
  shopt = 40
  complete = 41
  compgen = 42
  compopt = 43
  compadjust = 44
  compexport = 45
  getopts = 46
  builtin = 47
  command = 48
  type = 49
  hash = 50
  help = 51
  history = 52
  alias = 53
  unalias = 54
  bind = 55
  append = 56
  write = 57
  json = 58
  json8 = 59
  pp = 60
  hay = 61
  haynode = 62
  use = 63
  error = 64
  failed = 65
  fork = 66
  forkwait = 67
  redir = 68
  fopen = 69
  shvar = 70
  ctx = 71
  invoke = 72
  runproc = 73
  boolstatus = 74
  test = 75
  bracket = 76
  push_registers = 77
  source_guard = 78
  is_main = 79
  cat = 80
  rm = 81
  sleep = 82
  ARRAY_SIZE = 83

_builtin_str = {
  1: 'colon',
  2: 'dot',
  3: 'exec_',
  4: 'eval',
  5: 'set',
  6: 'shift',
  7: 'times',
  8: 'trap',
  9: 'unset',
  10: 'readonly',
  11: 'local',
  12: 'declare',
  13: 'typeset',
  14: 'export_',
  15: 'true_',
  16: 'false_',
  17: 'try_',
  18: 'assert_',
  19: 'break_',
  20: 'continue_',
  21: 'return_',
  22: 'exit',
  23: 'read',
  24: 'echo',
  25: 'printf',
  26: 'mapfile',
  27: 'readarray',
  28: 'cd',
  29: 'pushd',
  30: 'popd',
  31: 'dirs',
  32: 'pwd',
  33: 'source',
  34: 'umask',
  35: 'ulimit',
  36: 'wait',
  37: 'jobs',
  38: 'fg',
  39: 'bg',
  40: 'shopt',
  41: 'complete',
  42: 'compgen',
  43: 'compopt',
  44: 'compadjust',
  45: 'compexport',
  46: 'getopts',
  47: 'builtin',
  48: 'command',
  49: 'type',
  50: 'hash',
  51: 'help',
  52: 'history',
  53: 'alias',
  54: 'unalias',
  55: 'bind',
  56: 'append',
  57: 'write',
  58: 'json',
  59: 'json8',
  60: 'pp',
  61: 'hay',
  62: 'haynode',
  63: 'use',
  64: 'error',
  65: 'failed',
  66: 'fork',
  67: 'forkwait',
  68: 'redir',
  69: 'fopen',
  70: 'shvar',
  71: 'ctx',
  72: 'invoke',
  73: 'runproc',
  74: 'boolstatus',
  75: 'test',
  76: 'bracket',
  77: 'push_registers',
  78: 'source_guard',
  79: 'is_main',
  80: 'cat',
  81: 'rm',
  82: 'sleep',
}

def builtin_str(val, dot=True):
  # type: (builtin_t, bool) -> str
  v = _builtin_str[val]
  if dot:
    return "builtin.%s" % v
  else:
    return v

