from asdl import pybase

Id_t = int  # type alias for integer

class Id(object):
  Word_Compound = 1
  Arith_Semi = 2
  Arith_Comma = 3
  Arith_Plus = 4
  Arith_Minus = 5
  Arith_Star = 6
  Arith_Slash = 7
  Arith_Percent = 8
  Arith_DPlus = 9
  Arith_DMinus = 10
  Arith_DStar = 11
  Arith_LParen = 12
  Arith_RParen = 13
  Arith_LBracket = 14
  Arith_RBracket = 15
  Arith_RBrace = 16
  Arith_QMark = 17
  Arith_Colon = 18
  Arith_LessEqual = 19
  Arith_Less = 20
  Arith_GreatEqual = 21
  Arith_Great = 22
  Arith_DEqual = 23
  Arith_NEqual = 24
  Arith_DAmp = 25
  Arith_DPipe = 26
  Arith_Bang = 27
  Arith_DGreat = 28
  Arith_DLess = 29
  Arith_Amp = 30
  Arith_Pipe = 31
  Arith_Caret = 32
  Arith_Tilde = 33
  Arith_Equal = 34
  Arith_PlusEqual = 35
  Arith_MinusEqual = 36
  Arith_StarEqual = 37
  Arith_SlashEqual = 38
  Arith_PercentEqual = 39
  Arith_DGreatEqual = 40
  Arith_DLessEqual = 41
  Arith_AmpEqual = 42
  Arith_CaretEqual = 43
  Arith_PipeEqual = 44
  Eof_Real = 45
  Eof_RParen = 46
  Eof_Backtick = 47
  Undefined_Tok = 48
  Unknown_Tok = 49
  Unknown_Backslash = 50
  Unknown_DEqual = 51
  Unknown_DAmp = 52
  Unknown_DPipe = 53
  Unknown_DDot = 54
  Eol_Tok = 55
  Ignored_LineCont = 56
  Ignored_Space = 57
  Ignored_Comment = 58
  Ignored_Newline = 59
  WS_Space = 60
  Lit_Chars = 61
  Lit_CharsWithoutPrefix = 62
  Lit_VarLike = 63
  Lit_ArrayLhsOpen = 64
  Lit_ArrayLhsClose = 65
  Lit_Splice = 66
  Lit_AtLBracket = 67
  Lit_AtLBraceDot = 68
  Lit_Other = 69
  Lit_EscapedChar = 70
  Lit_LBracket = 71
  Lit_RBracket = 72
  Lit_Star = 73
  Lit_QMark = 74
  Lit_LBrace = 75
  Lit_RBrace = 76
  Lit_Comma = 77
  Lit_Equals = 78
  Lit_Dollar = 79
  Lit_DRightBracket = 80
  Lit_Tilde = 81
  Lit_Pound = 82
  Lit_TPound = 83
  Lit_TDot = 84
  Lit_Slash = 85
  Lit_Percent = 86
  Lit_Colon = 87
  Lit_Digits = 88
  Lit_At = 89
  Lit_ArithVarLike = 90
  Lit_BadBackslash = 91
  Lit_CompDummy = 92
  Backtick_Right = 93
  Backtick_Quoted = 94
  Backtick_DoubleQuote = 95
  Backtick_Other = 96
  History_Op = 97
  History_Num = 98
  History_Search = 99
  History_Other = 100
  Op_Newline = 101
  Op_Amp = 102
  Op_Pipe = 103
  Op_PipeAmp = 104
  Op_DAmp = 105
  Op_DPipe = 106
  Op_Semi = 107
  Op_DSemi = 108
  Op_SemiAmp = 109
  Op_DSemiAmp = 110
  Op_LParen = 111
  Op_RParen = 112
  Op_DLeftParen = 113
  Op_DRightParen = 114
  Op_Less = 115
  Op_Great = 116
  Op_Bang = 117
  Op_LBracket = 118
  Op_RBracket = 119
  Op_LBrace = 120
  Op_RBrace = 121
  Expr_Reserved = 122
  Expr_Symbol = 123
  Expr_Name = 124
  Expr_DecInt = 125
  Expr_BinInt = 126
  Expr_OctInt = 127
  Expr_HexInt = 128
  Expr_Float = 129
  Expr_Bang = 130
  Expr_Dot = 131
  Expr_DDotLessThan = 132
  Expr_DDotEqual = 133
  Expr_Colon = 134
  Expr_RArrow = 135
  Expr_RDArrow = 136
  Expr_DSlash = 137
  Expr_TEqual = 138
  Expr_NotDEqual = 139
  Expr_TildeDEqual = 140
  Expr_At = 141
  Expr_DoubleAt = 142
  Expr_Ellipsis = 143
  Expr_Dollar = 144
  Expr_NotTilde = 145
  Expr_DTilde = 146
  Expr_NotDTilde = 147
  Expr_DStarEqual = 148
  Expr_DSlashEqual = 149
  Expr_CastedDummy = 150
  Expr_Null = 151
  Expr_True = 152
  Expr_False = 153
  Expr_And = 154
  Expr_Or = 155
  Expr_Not = 156
  Expr_For = 157
  Expr_Is = 158
  Expr_In = 159
  Expr_If = 160
  Expr_Else = 161
  Expr_Capture = 162
  Expr_As = 163
  Expr_Func = 164
  Expr_Proc = 165
  Char_OneChar = 166
  Char_Stop = 167
  Char_Hex = 168
  Char_YHex = 169
  Char_Octal3 = 170
  Char_Octal4 = 171
  Char_Unicode4 = 172
  Char_SurrogatePair = 173
  Char_Unicode8 = 174
  Char_UBraced = 175
  Char_Pound = 176
  Char_AsciiControl = 177
  BashRegex_LParen = 178
  BashRegex_AllowedInParens = 179
  Eggex_Start = 180
  Eggex_End = 181
  Eggex_Dot = 182
  Redir_Less = 183
  Redir_Great = 184
  Redir_DLess = 185
  Redir_TLess = 186
  Redir_DGreat = 187
  Redir_GreatAnd = 188
  Redir_LessAnd = 189
  Redir_DLessDash = 190
  Redir_LessGreat = 191
  Redir_Clobber = 192
  Redir_AndGreat = 193
  Redir_AndDGreat = 194
  Left_DoubleQuote = 195
  Left_JDoubleQuote = 196
  Left_SingleQuote = 197
  Left_DollarSingleQuote = 198
  Left_RSingleQuote = 199
  Left_USingleQuote = 200
  Left_BSingleQuote = 201
  Left_TDoubleQuote = 202
  Left_DollarTDoubleQuote = 203
  Left_TSingleQuote = 204
  Left_RTSingleQuote = 205
  Left_UTSingleQuote = 206
  Left_BTSingleQuote = 207
  Left_Backtick = 208
  Left_DollarParen = 209
  Left_DollarBrace = 210
  Left_DollarBraceZsh = 211
  Left_DollarDParen = 212
  Left_DollarBracket = 213
  Left_DollarDoubleQuote = 214
  Left_ProcSubIn = 215
  Left_ProcSubOut = 216
  Left_AtParen = 217
  Left_CaretParen = 218
  Left_CaretBracket = 219
  Left_CaretBrace = 220
  Left_CaretDoubleQuote = 221
  Left_ColonPipe = 222
  Left_PercentParen = 223
  Right_DoubleQuote = 224
  Right_SingleQuote = 225
  Right_Backtick = 226
  Right_DollarBrace = 227
  Right_DollarDParen = 228
  Right_DollarDoubleQuote = 229
  Right_DollarSingleQuote = 230
  Right_Subshell = 231
  Right_ShFunction = 232
  Right_CasePat = 233
  Right_Initializer = 234
  Right_ExtGlob = 235
  Right_BashRegexGroup = 236
  Right_BlockLiteral = 237
  ExtGlob_Comma = 238
  ExtGlob_At = 239
  ExtGlob_Star = 240
  ExtGlob_Plus = 241
  ExtGlob_QMark = 242
  ExtGlob_Bang = 243
  VSub_DollarName = 244
  VSub_Name = 245
  VSub_Number = 246
  VSub_Bang = 247
  VSub_At = 248
  VSub_Pound = 249
  VSub_Dollar = 250
  VSub_Star = 251
  VSub_Hyphen = 252
  VSub_QMark = 253
  VSub_Dot = 254
  VTest_ColonHyphen = 255
  VTest_Hyphen = 256
  VTest_ColonEquals = 257
  VTest_Equals = 258
  VTest_ColonQMark = 259
  VTest_QMark = 260
  VTest_ColonPlus = 261
  VTest_Plus = 262
  VOp0_Q = 263
  VOp0_E = 264
  VOp0_P = 265
  VOp0_A = 266
  VOp0_a = 267
  VOp1_Percent = 268
  VOp1_DPercent = 269
  VOp1_Pound = 270
  VOp1_DPound = 271
  VOp1_Caret = 272
  VOp1_DCaret = 273
  VOp1_Comma = 274
  VOp1_DComma = 275
  VOpYsh_Pipe = 276
  VOpYsh_Space = 277
  VOp2_Slash = 278
  VOp2_Colon = 279
  VOp2_LBracket = 280
  VOp2_RBracket = 281
  VOp3_At = 282
  VOp3_Star = 283
  Node_PostDPlus = 284
  Node_PostDMinus = 285
  Node_UnaryPlus = 286
  Node_UnaryMinus = 287
  Node_NotIn = 288
  Node_IsNot = 289
  KW_DLeftBracket = 290
  KW_Bang = 291
  KW_For = 292
  KW_While = 293
  KW_Until = 294
  KW_Do = 295
  KW_Done = 296
  KW_In = 297
  KW_Case = 298
  KW_Esac = 299
  KW_If = 300
  KW_Fi = 301
  KW_Then = 302
  KW_Else = 303
  KW_Elif = 304
  KW_Function = 305
  KW_Time = 306
  KW_Const = 307
  KW_Var = 308
  KW_SetVar = 309
  KW_SetGlobal = 310
  KW_Call = 311
  KW_Proc = 312
  KW_Typed = 313
  KW_Func = 314
  ControlFlow_Break = 315
  ControlFlow_Continue = 316
  ControlFlow_Return = 317
  ControlFlow_Exit = 318
  LookAhead_FuncParens = 319
  Glob_LBracket = 320
  Glob_RBracket = 321
  Glob_Star = 322
  Glob_QMark = 323
  Glob_Bang = 324
  Glob_Caret = 325
  Glob_EscapedChar = 326
  Glob_BadBackslash = 327
  Glob_CleanLiterals = 328
  Glob_OtherLiteral = 329
  Format_EscapedPercent = 330
  Format_Percent = 331
  Format_Flag = 332
  Format_Num = 333
  Format_Dot = 334
  Format_Type = 335
  Format_Star = 336
  Format_Time = 337
  Format_Zero = 338
  PS_Subst = 339
  PS_Octal3 = 340
  PS_LBrace = 341
  PS_RBrace = 342
  PS_Literals = 343
  PS_BadBackslash = 344
  Range_Int = 345
  Range_Char = 346
  Range_Dots = 347
  Range_Other = 348
  J8_LBracket = 349
  J8_RBracket = 350
  J8_LBrace = 351
  J8_RBrace = 352
  J8_Comma = 353
  J8_Colon = 354
  J8_Null = 355
  J8_Bool = 356
  J8_Int = 357
  J8_Float = 358
  J8_String = 359
  J8_Identifier = 360
  J8_Newline = 361
  J8_Tab = 362
  J8_LParen = 363
  J8_RParen = 364
  J8_Operator = 365
  ShNumber_Dec = 366
  ShNumber_Hex = 367
  ShNumber_Oct = 368
  ShNumber_BaseN = 369
  BoolUnary_z = 370
  BoolUnary_n = 371
  BoolUnary_o = 372
  BoolUnary_t = 373
  BoolUnary_v = 374
  BoolUnary_R = 375
  BoolUnary_a = 376
  BoolUnary_b = 377
  BoolUnary_c = 378
  BoolUnary_d = 379
  BoolUnary_e = 380
  BoolUnary_f = 381
  BoolUnary_g = 382
  BoolUnary_h = 383
  BoolUnary_k = 384
  BoolUnary_L = 385
  BoolUnary_p = 386
  BoolUnary_r = 387
  BoolUnary_s = 388
  BoolUnary_S = 389
  BoolUnary_u = 390
  BoolUnary_w = 391
  BoolUnary_x = 392
  BoolUnary_O = 393
  BoolUnary_G = 394
  BoolUnary_N = 395
  BoolUnary_true = 396
  BoolUnary_false = 397
  BoolBinary_GlobEqual = 398
  BoolBinary_GlobDEqual = 399
  BoolBinary_GlobNEqual = 400
  BoolBinary_EqualTilde = 401
  BoolBinary_ef = 402
  BoolBinary_nt = 403
  BoolBinary_ot = 404
  BoolBinary_eq = 405
  BoolBinary_ne = 406
  BoolBinary_gt = 407
  BoolBinary_ge = 408
  BoolBinary_lt = 409
  BoolBinary_le = 410
  BoolBinary_Equal = 411
  BoolBinary_DEqual = 412
  BoolBinary_NEqual = 413
  ARRAY_SIZE = 414

_Id_str = {
  1: 'Word_Compound',
  2: 'Arith_Semi',
  3: 'Arith_Comma',
  4: 'Arith_Plus',
  5: 'Arith_Minus',
  6: 'Arith_Star',
  7: 'Arith_Slash',
  8: 'Arith_Percent',
  9: 'Arith_DPlus',
  10: 'Arith_DMinus',
  11: 'Arith_DStar',
  12: 'Arith_LParen',
  13: 'Arith_RParen',
  14: 'Arith_LBracket',
  15: 'Arith_RBracket',
  16: 'Arith_RBrace',
  17: 'Arith_QMark',
  18: 'Arith_Colon',
  19: 'Arith_LessEqual',
  20: 'Arith_Less',
  21: 'Arith_GreatEqual',
  22: 'Arith_Great',
  23: 'Arith_DEqual',
  24: 'Arith_NEqual',
  25: 'Arith_DAmp',
  26: 'Arith_DPipe',
  27: 'Arith_Bang',
  28: 'Arith_DGreat',
  29: 'Arith_DLess',
  30: 'Arith_Amp',
  31: 'Arith_Pipe',
  32: 'Arith_Caret',
  33: 'Arith_Tilde',
  34: 'Arith_Equal',
  35: 'Arith_PlusEqual',
  36: 'Arith_MinusEqual',
  37: 'Arith_StarEqual',
  38: 'Arith_SlashEqual',
  39: 'Arith_PercentEqual',
  40: 'Arith_DGreatEqual',
  41: 'Arith_DLessEqual',
  42: 'Arith_AmpEqual',
  43: 'Arith_CaretEqual',
  44: 'Arith_PipeEqual',
  45: 'Eof_Real',
  46: 'Eof_RParen',
  47: 'Eof_Backtick',
  48: 'Undefined_Tok',
  49: 'Unknown_Tok',
  50: 'Unknown_Backslash',
  51: 'Unknown_DEqual',
  52: 'Unknown_DAmp',
  53: 'Unknown_DPipe',
  54: 'Unknown_DDot',
  55: 'Eol_Tok',
  56: 'Ignored_LineCont',
  57: 'Ignored_Space',
  58: 'Ignored_Comment',
  59: 'Ignored_Newline',
  60: 'WS_Space',
  61: 'Lit_Chars',
  62: 'Lit_CharsWithoutPrefix',
  63: 'Lit_VarLike',
  64: 'Lit_ArrayLhsOpen',
  65: 'Lit_ArrayLhsClose',
  66: 'Lit_Splice',
  67: 'Lit_AtLBracket',
  68: 'Lit_AtLBraceDot',
  69: 'Lit_Other',
  70: 'Lit_EscapedChar',
  71: 'Lit_LBracket',
  72: 'Lit_RBracket',
  73: 'Lit_Star',
  74: 'Lit_QMark',
  75: 'Lit_LBrace',
  76: 'Lit_RBrace',
  77: 'Lit_Comma',
  78: 'Lit_Equals',
  79: 'Lit_Dollar',
  80: 'Lit_DRightBracket',
  81: 'Lit_Tilde',
  82: 'Lit_Pound',
  83: 'Lit_TPound',
  84: 'Lit_TDot',
  85: 'Lit_Slash',
  86: 'Lit_Percent',
  87: 'Lit_Colon',
  88: 'Lit_Digits',
  89: 'Lit_At',
  90: 'Lit_ArithVarLike',
  91: 'Lit_BadBackslash',
  92: 'Lit_CompDummy',
  93: 'Backtick_Right',
  94: 'Backtick_Quoted',
  95: 'Backtick_DoubleQuote',
  96: 'Backtick_Other',
  97: 'History_Op',
  98: 'History_Num',
  99: 'History_Search',
  100: 'History_Other',
  101: 'Op_Newline',
  102: 'Op_Amp',
  103: 'Op_Pipe',
  104: 'Op_PipeAmp',
  105: 'Op_DAmp',
  106: 'Op_DPipe',
  107: 'Op_Semi',
  108: 'Op_DSemi',
  109: 'Op_SemiAmp',
  110: 'Op_DSemiAmp',
  111: 'Op_LParen',
  112: 'Op_RParen',
  113: 'Op_DLeftParen',
  114: 'Op_DRightParen',
  115: 'Op_Less',
  116: 'Op_Great',
  117: 'Op_Bang',
  118: 'Op_LBracket',
  119: 'Op_RBracket',
  120: 'Op_LBrace',
  121: 'Op_RBrace',
  122: 'Expr_Reserved',
  123: 'Expr_Symbol',
  124: 'Expr_Name',
  125: 'Expr_DecInt',
  126: 'Expr_BinInt',
  127: 'Expr_OctInt',
  128: 'Expr_HexInt',
  129: 'Expr_Float',
  130: 'Expr_Bang',
  131: 'Expr_Dot',
  132: 'Expr_DDotLessThan',
  133: 'Expr_DDotEqual',
  134: 'Expr_Colon',
  135: 'Expr_RArrow',
  136: 'Expr_RDArrow',
  137: 'Expr_DSlash',
  138: 'Expr_TEqual',
  139: 'Expr_NotDEqual',
  140: 'Expr_TildeDEqual',
  141: 'Expr_At',
  142: 'Expr_DoubleAt',
  143: 'Expr_Ellipsis',
  144: 'Expr_Dollar',
  145: 'Expr_NotTilde',
  146: 'Expr_DTilde',
  147: 'Expr_NotDTilde',
  148: 'Expr_DStarEqual',
  149: 'Expr_DSlashEqual',
  150: 'Expr_CastedDummy',
  151: 'Expr_Null',
  152: 'Expr_True',
  153: 'Expr_False',
  154: 'Expr_And',
  155: 'Expr_Or',
  156: 'Expr_Not',
  157: 'Expr_For',
  158: 'Expr_Is',
  159: 'Expr_In',
  160: 'Expr_If',
  161: 'Expr_Else',
  162: 'Expr_Capture',
  163: 'Expr_As',
  164: 'Expr_Func',
  165: 'Expr_Proc',
  166: 'Char_OneChar',
  167: 'Char_Stop',
  168: 'Char_Hex',
  169: 'Char_YHex',
  170: 'Char_Octal3',
  171: 'Char_Octal4',
  172: 'Char_Unicode4',
  173: 'Char_SurrogatePair',
  174: 'Char_Unicode8',
  175: 'Char_UBraced',
  176: 'Char_Pound',
  177: 'Char_AsciiControl',
  178: 'BashRegex_LParen',
  179: 'BashRegex_AllowedInParens',
  180: 'Eggex_Start',
  181: 'Eggex_End',
  182: 'Eggex_Dot',
  183: 'Redir_Less',
  184: 'Redir_Great',
  185: 'Redir_DLess',
  186: 'Redir_TLess',
  187: 'Redir_DGreat',
  188: 'Redir_GreatAnd',
  189: 'Redir_LessAnd',
  190: 'Redir_DLessDash',
  191: 'Redir_LessGreat',
  192: 'Redir_Clobber',
  193: 'Redir_AndGreat',
  194: 'Redir_AndDGreat',
  195: 'Left_DoubleQuote',
  196: 'Left_JDoubleQuote',
  197: 'Left_SingleQuote',
  198: 'Left_DollarSingleQuote',
  199: 'Left_RSingleQuote',
  200: 'Left_USingleQuote',
  201: 'Left_BSingleQuote',
  202: 'Left_TDoubleQuote',
  203: 'Left_DollarTDoubleQuote',
  204: 'Left_TSingleQuote',
  205: 'Left_RTSingleQuote',
  206: 'Left_UTSingleQuote',
  207: 'Left_BTSingleQuote',
  208: 'Left_Backtick',
  209: 'Left_DollarParen',
  210: 'Left_DollarBrace',
  211: 'Left_DollarBraceZsh',
  212: 'Left_DollarDParen',
  213: 'Left_DollarBracket',
  214: 'Left_DollarDoubleQuote',
  215: 'Left_ProcSubIn',
  216: 'Left_ProcSubOut',
  217: 'Left_AtParen',
  218: 'Left_CaretParen',
  219: 'Left_CaretBracket',
  220: 'Left_CaretBrace',
  221: 'Left_CaretDoubleQuote',
  222: 'Left_ColonPipe',
  223: 'Left_PercentParen',
  224: 'Right_DoubleQuote',
  225: 'Right_SingleQuote',
  226: 'Right_Backtick',
  227: 'Right_DollarBrace',
  228: 'Right_DollarDParen',
  229: 'Right_DollarDoubleQuote',
  230: 'Right_DollarSingleQuote',
  231: 'Right_Subshell',
  232: 'Right_ShFunction',
  233: 'Right_CasePat',
  234: 'Right_Initializer',
  235: 'Right_ExtGlob',
  236: 'Right_BashRegexGroup',
  237: 'Right_BlockLiteral',
  238: 'ExtGlob_Comma',
  239: 'ExtGlob_At',
  240: 'ExtGlob_Star',
  241: 'ExtGlob_Plus',
  242: 'ExtGlob_QMark',
  243: 'ExtGlob_Bang',
  244: 'VSub_DollarName',
  245: 'VSub_Name',
  246: 'VSub_Number',
  247: 'VSub_Bang',
  248: 'VSub_At',
  249: 'VSub_Pound',
  250: 'VSub_Dollar',
  251: 'VSub_Star',
  252: 'VSub_Hyphen',
  253: 'VSub_QMark',
  254: 'VSub_Dot',
  255: 'VTest_ColonHyphen',
  256: 'VTest_Hyphen',
  257: 'VTest_ColonEquals',
  258: 'VTest_Equals',
  259: 'VTest_ColonQMark',
  260: 'VTest_QMark',
  261: 'VTest_ColonPlus',
  262: 'VTest_Plus',
  263: 'VOp0_Q',
  264: 'VOp0_E',
  265: 'VOp0_P',
  266: 'VOp0_A',
  267: 'VOp0_a',
  268: 'VOp1_Percent',
  269: 'VOp1_DPercent',
  270: 'VOp1_Pound',
  271: 'VOp1_DPound',
  272: 'VOp1_Caret',
  273: 'VOp1_DCaret',
  274: 'VOp1_Comma',
  275: 'VOp1_DComma',
  276: 'VOpYsh_Pipe',
  277: 'VOpYsh_Space',
  278: 'VOp2_Slash',
  279: 'VOp2_Colon',
  280: 'VOp2_LBracket',
  281: 'VOp2_RBracket',
  282: 'VOp3_At',
  283: 'VOp3_Star',
  284: 'Node_PostDPlus',
  285: 'Node_PostDMinus',
  286: 'Node_UnaryPlus',
  287: 'Node_UnaryMinus',
  288: 'Node_NotIn',
  289: 'Node_IsNot',
  290: 'KW_DLeftBracket',
  291: 'KW_Bang',
  292: 'KW_For',
  293: 'KW_While',
  294: 'KW_Until',
  295: 'KW_Do',
  296: 'KW_Done',
  297: 'KW_In',
  298: 'KW_Case',
  299: 'KW_Esac',
  300: 'KW_If',
  301: 'KW_Fi',
  302: 'KW_Then',
  303: 'KW_Else',
  304: 'KW_Elif',
  305: 'KW_Function',
  306: 'KW_Time',
  307: 'KW_Const',
  308: 'KW_Var',
  309: 'KW_SetVar',
  310: 'KW_SetGlobal',
  311: 'KW_Call',
  312: 'KW_Proc',
  313: 'KW_Typed',
  314: 'KW_Func',
  315: 'ControlFlow_Break',
  316: 'ControlFlow_Continue',
  317: 'ControlFlow_Return',
  318: 'ControlFlow_Exit',
  319: 'LookAhead_FuncParens',
  320: 'Glob_LBracket',
  321: 'Glob_RBracket',
  322: 'Glob_Star',
  323: 'Glob_QMark',
  324: 'Glob_Bang',
  325: 'Glob_Caret',
  326: 'Glob_EscapedChar',
  327: 'Glob_BadBackslash',
  328: 'Glob_CleanLiterals',
  329: 'Glob_OtherLiteral',
  330: 'Format_EscapedPercent',
  331: 'Format_Percent',
  332: 'Format_Flag',
  333: 'Format_Num',
  334: 'Format_Dot',
  335: 'Format_Type',
  336: 'Format_Star',
  337: 'Format_Time',
  338: 'Format_Zero',
  339: 'PS_Subst',
  340: 'PS_Octal3',
  341: 'PS_LBrace',
  342: 'PS_RBrace',
  343: 'PS_Literals',
  344: 'PS_BadBackslash',
  345: 'Range_Int',
  346: 'Range_Char',
  347: 'Range_Dots',
  348: 'Range_Other',
  349: 'J8_LBracket',
  350: 'J8_RBracket',
  351: 'J8_LBrace',
  352: 'J8_RBrace',
  353: 'J8_Comma',
  354: 'J8_Colon',
  355: 'J8_Null',
  356: 'J8_Bool',
  357: 'J8_Int',
  358: 'J8_Float',
  359: 'J8_String',
  360: 'J8_Identifier',
  361: 'J8_Newline',
  362: 'J8_Tab',
  363: 'J8_LParen',
  364: 'J8_RParen',
  365: 'J8_Operator',
  366: 'ShNumber_Dec',
  367: 'ShNumber_Hex',
  368: 'ShNumber_Oct',
  369: 'ShNumber_BaseN',
  370: 'BoolUnary_z',
  371: 'BoolUnary_n',
  372: 'BoolUnary_o',
  373: 'BoolUnary_t',
  374: 'BoolUnary_v',
  375: 'BoolUnary_R',
  376: 'BoolUnary_a',
  377: 'BoolUnary_b',
  378: 'BoolUnary_c',
  379: 'BoolUnary_d',
  380: 'BoolUnary_e',
  381: 'BoolUnary_f',
  382: 'BoolUnary_g',
  383: 'BoolUnary_h',
  384: 'BoolUnary_k',
  385: 'BoolUnary_L',
  386: 'BoolUnary_p',
  387: 'BoolUnary_r',
  388: 'BoolUnary_s',
  389: 'BoolUnary_S',
  390: 'BoolUnary_u',
  391: 'BoolUnary_w',
  392: 'BoolUnary_x',
  393: 'BoolUnary_O',
  394: 'BoolUnary_G',
  395: 'BoolUnary_N',
  396: 'BoolUnary_true',
  397: 'BoolUnary_false',
  398: 'BoolBinary_GlobEqual',
  399: 'BoolBinary_GlobDEqual',
  400: 'BoolBinary_GlobNEqual',
  401: 'BoolBinary_EqualTilde',
  402: 'BoolBinary_ef',
  403: 'BoolBinary_nt',
  404: 'BoolBinary_ot',
  405: 'BoolBinary_eq',
  406: 'BoolBinary_ne',
  407: 'BoolBinary_gt',
  408: 'BoolBinary_ge',
  409: 'BoolBinary_lt',
  410: 'BoolBinary_le',
  411: 'BoolBinary_Equal',
  412: 'BoolBinary_DEqual',
  413: 'BoolBinary_NEqual',
}

def Id_str(val, dot=True):
  # type: (Id_t, bool) -> str
  v = _Id_str[val]
  if dot:
    return "Id.%s" % v
  else:
    return v

class Kind_t(pybase.SimpleObj):
  pass

class Kind(object):
  Word = Kind_t(1)
  Arith = Kind_t(2)
  Eof = Kind_t(3)
  Undefined = Kind_t(4)
  Unknown = Kind_t(5)
  Eol = Kind_t(6)
  Ignored = Kind_t(7)
  WS = Kind_t(8)
  Lit = Kind_t(9)
  Backtick = Kind_t(10)
  History = Kind_t(11)
  Op = Kind_t(12)
  Expr = Kind_t(13)
  Char = Kind_t(14)
  BashRegex = Kind_t(15)
  Eggex = Kind_t(16)
  Redir = Kind_t(17)
  Left = Kind_t(18)
  Right = Kind_t(19)
  ExtGlob = Kind_t(20)
  VSub = Kind_t(21)
  VTest = Kind_t(22)
  VOp0 = Kind_t(23)
  VOp1 = Kind_t(24)
  VOpYsh = Kind_t(25)
  VOp2 = Kind_t(26)
  VOp3 = Kind_t(27)
  Node = Kind_t(28)
  KW = Kind_t(29)
  ControlFlow = Kind_t(30)
  LookAhead = Kind_t(31)
  Glob = Kind_t(32)
  Format = Kind_t(33)
  PS = Kind_t(34)
  Range = Kind_t(35)
  J8 = Kind_t(36)
  ShNumber = Kind_t(37)
  BoolUnary = Kind_t(38)
  BoolBinary = Kind_t(39)

_Kind_str = {
  1: 'Word',
  2: 'Arith',
  3: 'Eof',
  4: 'Undefined',
  5: 'Unknown',
  6: 'Eol',
  7: 'Ignored',
  8: 'WS',
  9: 'Lit',
  10: 'Backtick',
  11: 'History',
  12: 'Op',
  13: 'Expr',
  14: 'Char',
  15: 'BashRegex',
  16: 'Eggex',
  17: 'Redir',
  18: 'Left',
  19: 'Right',
  20: 'ExtGlob',
  21: 'VSub',
  22: 'VTest',
  23: 'VOp0',
  24: 'VOp1',
  25: 'VOpYsh',
  26: 'VOp2',
  27: 'VOp3',
  28: 'Node',
  29: 'KW',
  30: 'ControlFlow',
  31: 'LookAhead',
  32: 'Glob',
  33: 'Format',
  34: 'PS',
  35: 'Range',
  36: 'J8',
  37: 'ShNumber',
  38: 'BoolUnary',
  39: 'BoolBinary',
}

def Kind_str(val, dot=True):
  # type: (Kind_t, bool) -> str
  v = _Kind_str[val]
  if dot:
    return "Kind.%s" % v
  else:
    return v

