from asdl import pybase

option_t = int  # type alias for integer

class option_i(object):
  errexit = 1
  nounset = 2
  pipefail = 3
  inherit_errexit = 4
  nullglob = 5
  verbose_errexit = 6
  noexec = 7
  xtrace = 8
  verbose = 9
  noglob = 10
  noclobber = 11
  errtrace = 12
  posix = 13
  vi = 14
  emacs = 15
  interactive = 16
  hashall = 17
  failglob = 18
  extglob = 19
  nocasematch = 20
  no_copy_env = 21
  eval_unsafe_arith = 22
  ignore_flags_not_impl = 23
  ignore_opts_not_impl = 24
  _allow_command_sub = 25
  _allow_process_sub = 26
  dynamic_scope = 27
  redefine_module = 28
  _running_trap = 29
  _running_hay = 30
  _no_debug_trap = 31
  _no_err_trap = 32
  strict_parse_slice = 33
  strict_argv = 34
  strict_arith = 35
  strict_array = 36
  strict_control_flow = 37
  strict_errexit = 38
  strict_nameref = 39
  strict_word_eval = 40
  strict_tilde = 41
  strict_glob = 42
  parse_at = 43
  parse_proc = 44
  parse_func = 45
  parse_brace = 46
  parse_bracket = 47
  parse_equals = 48
  parse_paren = 49
  parse_ysh_string = 50
  parse_triple_quote = 51
  simple_word_eval = 52
  dashglob = 53
  command_sub_errexit = 54
  process_sub_fail = 55
  xtrace_rich = 56
  xtrace_details = 57
  sigpipe_status_ok = 58
  redefine_proc_func = 59
  parse_at_all = 60
  parse_backslash = 61
  parse_backticks = 62
  parse_dollar = 63
  parse_ignored = 64
  parse_sh_arith = 65
  parse_dparen = 66
  parse_dbracket = 67
  parse_bare_word = 68
  simple_echo = 69
  simple_eval_builtin = 70
  simple_test_builtin = 71
  expand_aliases = 72
  lastpipe = 73
  progcomp = 74
  histappend = 75
  hostcomplete = 76
  cmdhist = 77
  assoc_expand_once = 78
  autocd = 79
  cdable_vars = 80
  cdspell = 81
  checkhash = 82
  checkjobs = 83
  checkwinsize = 84
  complete_fullquote = 85
  direxpand = 86
  dirspell = 87
  dotglob = 88
  execfail = 89
  extdebug = 90
  extquote = 91
  force_fignore = 92
  globasciiranges = 93
  globstar = 94
  gnu_errfmt = 95
  histreedit = 96
  histverify = 97
  huponexit = 98
  interactive_comments = 99
  lithist = 100
  localvar_inherit = 101
  localvar_unset = 102
  login_shell = 103
  mailwarn = 104
  no_empty_cmd_completion = 105
  nocaseglob = 106
  progcomp_alias = 107
  promptvars = 108
  restricted_shell = 109
  shift_verbose = 110
  sourcepath = 111
  xpg_echo = 112
  ARRAY_SIZE = 113

_option_str = {
  1: 'option.errexit',
  2: 'option.nounset',
  3: 'option.pipefail',
  4: 'option.inherit_errexit',
  5: 'option.nullglob',
  6: 'option.verbose_errexit',
  7: 'option.noexec',
  8: 'option.xtrace',
  9: 'option.verbose',
  10: 'option.noglob',
  11: 'option.noclobber',
  12: 'option.errtrace',
  13: 'option.posix',
  14: 'option.vi',
  15: 'option.emacs',
  16: 'option.interactive',
  17: 'option.hashall',
  18: 'option.failglob',
  19: 'option.extglob',
  20: 'option.nocasematch',
  21: 'option.no_copy_env',
  22: 'option.eval_unsafe_arith',
  23: 'option.ignore_flags_not_impl',
  24: 'option.ignore_opts_not_impl',
  25: 'option._allow_command_sub',
  26: 'option._allow_process_sub',
  27: 'option.dynamic_scope',
  28: 'option.redefine_module',
  29: 'option._running_trap',
  30: 'option._running_hay',
  31: 'option._no_debug_trap',
  32: 'option._no_err_trap',
  33: 'option.strict_parse_slice',
  34: 'option.strict_argv',
  35: 'option.strict_arith',
  36: 'option.strict_array',
  37: 'option.strict_control_flow',
  38: 'option.strict_errexit',
  39: 'option.strict_nameref',
  40: 'option.strict_word_eval',
  41: 'option.strict_tilde',
  42: 'option.strict_glob',
  43: 'option.parse_at',
  44: 'option.parse_proc',
  45: 'option.parse_func',
  46: 'option.parse_brace',
  47: 'option.parse_bracket',
  48: 'option.parse_equals',
  49: 'option.parse_paren',
  50: 'option.parse_ysh_string',
  51: 'option.parse_triple_quote',
  52: 'option.simple_word_eval',
  53: 'option.dashglob',
  54: 'option.command_sub_errexit',
  55: 'option.process_sub_fail',
  56: 'option.xtrace_rich',
  57: 'option.xtrace_details',
  58: 'option.sigpipe_status_ok',
  59: 'option.redefine_proc_func',
  60: 'option.parse_at_all',
  61: 'option.parse_backslash',
  62: 'option.parse_backticks',
  63: 'option.parse_dollar',
  64: 'option.parse_ignored',
  65: 'option.parse_sh_arith',
  66: 'option.parse_dparen',
  67: 'option.parse_dbracket',
  68: 'option.parse_bare_word',
  69: 'option.simple_echo',
  70: 'option.simple_eval_builtin',
  71: 'option.simple_test_builtin',
  72: 'option.expand_aliases',
  73: 'option.lastpipe',
  74: 'option.progcomp',
  75: 'option.histappend',
  76: 'option.hostcomplete',
  77: 'option.cmdhist',
  78: 'option.assoc_expand_once',
  79: 'option.autocd',
  80: 'option.cdable_vars',
  81: 'option.cdspell',
  82: 'option.checkhash',
  83: 'option.checkjobs',
  84: 'option.checkwinsize',
  85: 'option.complete_fullquote',
  86: 'option.direxpand',
  87: 'option.dirspell',
  88: 'option.dotglob',
  89: 'option.execfail',
  90: 'option.extdebug',
  91: 'option.extquote',
  92: 'option.force_fignore',
  93: 'option.globasciiranges',
  94: 'option.globstar',
  95: 'option.gnu_errfmt',
  96: 'option.histreedit',
  97: 'option.histverify',
  98: 'option.huponexit',
  99: 'option.interactive_comments',
  100: 'option.lithist',
  101: 'option.localvar_inherit',
  102: 'option.localvar_unset',
  103: 'option.login_shell',
  104: 'option.mailwarn',
  105: 'option.no_empty_cmd_completion',
  106: 'option.nocaseglob',
  107: 'option.progcomp_alias',
  108: 'option.promptvars',
  109: 'option.restricted_shell',
  110: 'option.shift_verbose',
  111: 'option.sourcepath',
  112: 'option.xpg_echo',
}

def option_str(val):
  # type: (option_t) -> str
  return _option_str[val]

builtin_t = int  # type alias for integer

class builtin_i(object):
  colon = 1
  dot = 2
  exec_ = 3
  eval = 4
  set = 5
  shift = 6
  times = 7
  trap = 8
  unset = 9
  readonly = 10
  local = 11
  declare = 12
  typeset = 13
  export_ = 14
  true_ = 15
  false_ = 16
  try_ = 17
  assert_ = 18
  read = 19
  echo = 20
  printf = 21
  mapfile = 22
  readarray = 23
  cd = 24
  pushd = 25
  popd = 26
  dirs = 27
  pwd = 28
  source = 29
  umask = 30
  ulimit = 31
  wait = 32
  jobs = 33
  fg = 34
  bg = 35
  shopt = 36
  complete = 37
  compgen = 38
  compopt = 39
  compadjust = 40
  compexport = 41
  getopts = 42
  builtin = 43
  command = 44
  type = 45
  hash = 46
  help = 47
  history = 48
  alias = 49
  unalias = 50
  bind = 51
  append = 52
  write = 53
  json = 54
  json8 = 55
  pp = 56
  hay = 57
  haynode = 58
  use = 59
  error = 60
  failed = 61
  fork = 62
  forkwait = 63
  fopen = 64
  shvar = 65
  ctx = 66
  runproc = 67
  boolstatus = 68
  test = 69
  bracket = 70
  push_registers = 71
  source_guard = 72
  is_main = 73
  cat = 74
  ARRAY_SIZE = 75

_builtin_str = {
  1: 'builtin.colon',
  2: 'builtin.dot',
  3: 'builtin.exec_',
  4: 'builtin.eval',
  5: 'builtin.set',
  6: 'builtin.shift',
  7: 'builtin.times',
  8: 'builtin.trap',
  9: 'builtin.unset',
  10: 'builtin.readonly',
  11: 'builtin.local',
  12: 'builtin.declare',
  13: 'builtin.typeset',
  14: 'builtin.export_',
  15: 'builtin.true_',
  16: 'builtin.false_',
  17: 'builtin.try_',
  18: 'builtin.assert_',
  19: 'builtin.read',
  20: 'builtin.echo',
  21: 'builtin.printf',
  22: 'builtin.mapfile',
  23: 'builtin.readarray',
  24: 'builtin.cd',
  25: 'builtin.pushd',
  26: 'builtin.popd',
  27: 'builtin.dirs',
  28: 'builtin.pwd',
  29: 'builtin.source',
  30: 'builtin.umask',
  31: 'builtin.ulimit',
  32: 'builtin.wait',
  33: 'builtin.jobs',
  34: 'builtin.fg',
  35: 'builtin.bg',
  36: 'builtin.shopt',
  37: 'builtin.complete',
  38: 'builtin.compgen',
  39: 'builtin.compopt',
  40: 'builtin.compadjust',
  41: 'builtin.compexport',
  42: 'builtin.getopts',
  43: 'builtin.builtin',
  44: 'builtin.command',
  45: 'builtin.type',
  46: 'builtin.hash',
  47: 'builtin.help',
  48: 'builtin.history',
  49: 'builtin.alias',
  50: 'builtin.unalias',
  51: 'builtin.bind',
  52: 'builtin.append',
  53: 'builtin.write',
  54: 'builtin.json',
  55: 'builtin.json8',
  56: 'builtin.pp',
  57: 'builtin.hay',
  58: 'builtin.haynode',
  59: 'builtin.use',
  60: 'builtin.error',
  61: 'builtin.failed',
  62: 'builtin.fork',
  63: 'builtin.forkwait',
  64: 'builtin.fopen',
  65: 'builtin.shvar',
  66: 'builtin.ctx',
  67: 'builtin.runproc',
  68: 'builtin.boolstatus',
  69: 'builtin.test',
  70: 'builtin.bracket',
  71: 'builtin.push_registers',
  72: 'builtin.source_guard',
  73: 'builtin.is_main',
  74: 'builtin.cat',
}

def builtin_str(val):
  # type: (builtin_t) -> str
  return _builtin_str[val]

