#ifndef ID_KIND_ASDL_H
#define ID_KIND_ASDL_H

#include <stdint.h>  // uint16_t

class BigStr;

namespace id_kind_asdl {

#define ASDL_NAMES struct
ASDL_NAMES Id {
  enum no_name {
  Word_Compound = 1,
  Arith_Semi = 2,
  Arith_Comma = 3,
  Arith_Plus = 4,
  Arith_Minus = 5,
  Arith_Star = 6,
  Arith_Slash = 7,
  Arith_Percent = 8,
  Arith_DPlus = 9,
  Arith_DMinus = 10,
  Arith_DStar = 11,
  Arith_LParen = 12,
  Arith_RParen = 13,
  Arith_LBracket = 14,
  Arith_RBracket = 15,
  Arith_RBrace = 16,
  Arith_QMark = 17,
  Arith_Colon = 18,
  Arith_LessEqual = 19,
  Arith_Less = 20,
  Arith_GreatEqual = 21,
  Arith_Great = 22,
  Arith_DEqual = 23,
  Arith_NEqual = 24,
  Arith_DAmp = 25,
  Arith_DPipe = 26,
  Arith_Bang = 27,
  Arith_DGreat = 28,
  Arith_DLess = 29,
  Arith_Amp = 30,
  Arith_Pipe = 31,
  Arith_Caret = 32,
  Arith_Tilde = 33,
  Arith_Equal = 34,
  Arith_PlusEqual = 35,
  Arith_MinusEqual = 36,
  Arith_StarEqual = 37,
  Arith_SlashEqual = 38,
  Arith_PercentEqual = 39,
  Arith_DGreatEqual = 40,
  Arith_DLessEqual = 41,
  Arith_AmpEqual = 42,
  Arith_CaretEqual = 43,
  Arith_PipeEqual = 44,
  Eof_Real = 45,
  Eof_RParen = 46,
  Eof_Backtick = 47,
  Undefined_Tok = 48,
  Unknown_Tok = 49,
  Unknown_Backslash = 50,
  Unknown_DEqual = 51,
  Eol_Tok = 52,
  Ignored_LineCont = 53,
  Ignored_Space = 54,
  Ignored_Comment = 55,
  Ignored_Newline = 56,
  WS_Space = 57,
  Lit_Chars = 58,
  Lit_CharsWithoutPrefix = 59,
  Lit_VarLike = 60,
  Lit_ArrayLhsOpen = 61,
  Lit_ArrayLhsClose = 62,
  Lit_Splice = 63,
  Lit_AtLBracket = 64,
  Lit_AtLBraceDot = 65,
  Lit_Other = 66,
  Lit_EscapedChar = 67,
  Lit_LBracket = 68,
  Lit_RBracket = 69,
  Lit_Star = 70,
  Lit_QMark = 71,
  Lit_LBrace = 72,
  Lit_RBrace = 73,
  Lit_Comma = 74,
  Lit_Equals = 75,
  Lit_Dollar = 76,
  Lit_DRightBracket = 77,
  Lit_Tilde = 78,
  Lit_Pound = 79,
  Lit_TPound = 80,
  Lit_TDot = 81,
  Lit_Slash = 82,
  Lit_Percent = 83,
  Lit_Colon = 84,
  Lit_Digits = 85,
  Lit_At = 86,
  Lit_ArithVarLike = 87,
  Lit_BadBackslash = 88,
  Lit_CompDummy = 89,
  Backtick_Right = 90,
  Backtick_Quoted = 91,
  Backtick_DoubleQuote = 92,
  Backtick_Other = 93,
  History_Op = 94,
  History_Num = 95,
  History_Search = 96,
  History_Other = 97,
  Op_Newline = 98,
  Op_Amp = 99,
  Op_Pipe = 100,
  Op_PipeAmp = 101,
  Op_DAmp = 102,
  Op_DPipe = 103,
  Op_Semi = 104,
  Op_DSemi = 105,
  Op_SemiAmp = 106,
  Op_DSemiAmp = 107,
  Op_LParen = 108,
  Op_RParen = 109,
  Op_DLeftParen = 110,
  Op_DRightParen = 111,
  Op_Less = 112,
  Op_Great = 113,
  Op_Bang = 114,
  Op_LBracket = 115,
  Op_RBracket = 116,
  Op_LBrace = 117,
  Op_RBrace = 118,
  Expr_Reserved = 119,
  Expr_Symbol = 120,
  Expr_Name = 121,
  Expr_DecInt = 122,
  Expr_BinInt = 123,
  Expr_OctInt = 124,
  Expr_HexInt = 125,
  Expr_Float = 126,
  Expr_Bang = 127,
  Expr_Dot = 128,
  Expr_DDot = 129,
  Expr_Colon = 130,
  Expr_RArrow = 131,
  Expr_RDArrow = 132,
  Expr_DSlash = 133,
  Expr_TEqual = 134,
  Expr_NotDEqual = 135,
  Expr_TildeDEqual = 136,
  Expr_At = 137,
  Expr_DoubleAt = 138,
  Expr_Ellipsis = 139,
  Expr_Dollar = 140,
  Expr_NotTilde = 141,
  Expr_DTilde = 142,
  Expr_NotDTilde = 143,
  Expr_DStarEqual = 144,
  Expr_DSlashEqual = 145,
  Expr_CastedDummy = 146,
  Expr_Null = 147,
  Expr_True = 148,
  Expr_False = 149,
  Expr_And = 150,
  Expr_Or = 151,
  Expr_Not = 152,
  Expr_For = 153,
  Expr_Is = 154,
  Expr_In = 155,
  Expr_If = 156,
  Expr_Else = 157,
  Expr_Func = 158,
  Expr_Capture = 159,
  Expr_As = 160,
  Char_OneChar = 161,
  Char_Stop = 162,
  Char_Hex = 163,
  Char_YHex = 164,
  Char_Octal3 = 165,
  Char_Octal4 = 166,
  Char_Unicode4 = 167,
  Char_SurrogatePair = 168,
  Char_Unicode8 = 169,
  Char_UBraced = 170,
  Char_Pound = 171,
  Char_AsciiControl = 172,
  BashRegex_LParen = 173,
  BashRegex_AllowedInParens = 174,
  Eggex_Start = 175,
  Eggex_End = 176,
  Eggex_Dot = 177,
  Redir_Less = 178,
  Redir_Great = 179,
  Redir_DLess = 180,
  Redir_TLess = 181,
  Redir_DGreat = 182,
  Redir_GreatAnd = 183,
  Redir_LessAnd = 184,
  Redir_DLessDash = 185,
  Redir_LessGreat = 186,
  Redir_Clobber = 187,
  Redir_AndGreat = 188,
  Redir_AndDGreat = 189,
  Left_DoubleQuote = 190,
  Left_JDoubleQuote = 191,
  Left_SingleQuote = 192,
  Left_DollarSingleQuote = 193,
  Left_RSingleQuote = 194,
  Left_USingleQuote = 195,
  Left_BSingleQuote = 196,
  Left_TDoubleQuote = 197,
  Left_DollarTDoubleQuote = 198,
  Left_TSingleQuote = 199,
  Left_RTSingleQuote = 200,
  Left_UTSingleQuote = 201,
  Left_BTSingleQuote = 202,
  Left_Backtick = 203,
  Left_DollarParen = 204,
  Left_DollarBrace = 205,
  Left_DollarBraceZsh = 206,
  Left_DollarDParen = 207,
  Left_DollarBracket = 208,
  Left_DollarDoubleQuote = 209,
  Left_ProcSubIn = 210,
  Left_ProcSubOut = 211,
  Left_AtParen = 212,
  Left_CaretParen = 213,
  Left_CaretBracket = 214,
  Left_CaretBrace = 215,
  Left_CaretDoubleQuote = 216,
  Left_ColonPipe = 217,
  Left_PercentParen = 218,
  Right_DoubleQuote = 219,
  Right_SingleQuote = 220,
  Right_Backtick = 221,
  Right_DollarBrace = 222,
  Right_DollarDParen = 223,
  Right_DollarDoubleQuote = 224,
  Right_DollarSingleQuote = 225,
  Right_Subshell = 226,
  Right_ShFunction = 227,
  Right_CasePat = 228,
  Right_ShArrayLiteral = 229,
  Right_ExtGlob = 230,
  Right_BashRegexGroup = 231,
  Right_BlockLiteral = 232,
  ExtGlob_Comma = 233,
  ExtGlob_At = 234,
  ExtGlob_Star = 235,
  ExtGlob_Plus = 236,
  ExtGlob_QMark = 237,
  ExtGlob_Bang = 238,
  VSub_DollarName = 239,
  VSub_Name = 240,
  VSub_Number = 241,
  VSub_Bang = 242,
  VSub_At = 243,
  VSub_Pound = 244,
  VSub_Dollar = 245,
  VSub_Star = 246,
  VSub_Hyphen = 247,
  VSub_QMark = 248,
  VSub_Dot = 249,
  VTest_ColonHyphen = 250,
  VTest_Hyphen = 251,
  VTest_ColonEquals = 252,
  VTest_Equals = 253,
  VTest_ColonQMark = 254,
  VTest_QMark = 255,
  VTest_ColonPlus = 256,
  VTest_Plus = 257,
  VOp0_Q = 258,
  VOp0_E = 259,
  VOp0_P = 260,
  VOp0_A = 261,
  VOp0_a = 262,
  VOp1_Percent = 263,
  VOp1_DPercent = 264,
  VOp1_Pound = 265,
  VOp1_DPound = 266,
  VOp1_Caret = 267,
  VOp1_DCaret = 268,
  VOp1_Comma = 269,
  VOp1_DComma = 270,
  VOpYsh_Pipe = 271,
  VOpYsh_Space = 272,
  VOp2_Slash = 273,
  VOp2_Colon = 274,
  VOp2_LBracket = 275,
  VOp2_RBracket = 276,
  VOp3_At = 277,
  VOp3_Star = 278,
  Node_PostDPlus = 279,
  Node_PostDMinus = 280,
  Node_UnaryPlus = 281,
  Node_UnaryMinus = 282,
  Node_NotIn = 283,
  Node_IsNot = 284,
  KW_DLeftBracket = 285,
  KW_Bang = 286,
  KW_For = 287,
  KW_While = 288,
  KW_Until = 289,
  KW_Do = 290,
  KW_Done = 291,
  KW_In = 292,
  KW_Case = 293,
  KW_Esac = 294,
  KW_If = 295,
  KW_Fi = 296,
  KW_Then = 297,
  KW_Else = 298,
  KW_Elif = 299,
  KW_Function = 300,
  KW_Time = 301,
  KW_Const = 302,
  KW_Var = 303,
  KW_SetVar = 304,
  KW_SetGlobal = 305,
  KW_Call = 306,
  KW_Proc = 307,
  KW_Typed = 308,
  KW_Func = 309,
  ControlFlow_Break = 310,
  ControlFlow_Continue = 311,
  ControlFlow_Return = 312,
  ControlFlow_Exit = 313,
  LookAhead_FuncParens = 314,
  Glob_LBracket = 315,
  Glob_RBracket = 316,
  Glob_Star = 317,
  Glob_QMark = 318,
  Glob_Bang = 319,
  Glob_Caret = 320,
  Glob_EscapedChar = 321,
  Glob_BadBackslash = 322,
  Glob_CleanLiterals = 323,
  Glob_OtherLiteral = 324,
  Format_EscapedPercent = 325,
  Format_Percent = 326,
  Format_Flag = 327,
  Format_Num = 328,
  Format_Dot = 329,
  Format_Type = 330,
  Format_Star = 331,
  Format_Time = 332,
  Format_Zero = 333,
  PS_Subst = 334,
  PS_Octal3 = 335,
  PS_LBrace = 336,
  PS_RBrace = 337,
  PS_Literals = 338,
  PS_BadBackslash = 339,
  Range_Int = 340,
  Range_Char = 341,
  Range_Dots = 342,
  Range_Other = 343,
  J8_LBracket = 344,
  J8_RBracket = 345,
  J8_LBrace = 346,
  J8_RBrace = 347,
  J8_Comma = 348,
  J8_Colon = 349,
  J8_Null = 350,
  J8_Bool = 351,
  J8_Int = 352,
  J8_Float = 353,
  J8_String = 354,
  J8_Identifier = 355,
  J8_Newline = 356,
  J8_Tab = 357,
  J8_LParen = 358,
  J8_RParen = 359,
  J8_Operator = 360,
  BoolUnary_z = 361,
  BoolUnary_n = 362,
  BoolUnary_o = 363,
  BoolUnary_t = 364,
  BoolUnary_v = 365,
  BoolUnary_R = 366,
  BoolUnary_a = 367,
  BoolUnary_b = 368,
  BoolUnary_c = 369,
  BoolUnary_d = 370,
  BoolUnary_e = 371,
  BoolUnary_f = 372,
  BoolUnary_g = 373,
  BoolUnary_h = 374,
  BoolUnary_k = 375,
  BoolUnary_L = 376,
  BoolUnary_p = 377,
  BoolUnary_r = 378,
  BoolUnary_s = 379,
  BoolUnary_S = 380,
  BoolUnary_u = 381,
  BoolUnary_w = 382,
  BoolUnary_x = 383,
  BoolUnary_O = 384,
  BoolUnary_G = 385,
  BoolUnary_N = 386,
  BoolBinary_GlobEqual = 387,
  BoolBinary_GlobDEqual = 388,
  BoolBinary_GlobNEqual = 389,
  BoolBinary_EqualTilde = 390,
  BoolBinary_ef = 391,
  BoolBinary_nt = 392,
  BoolBinary_ot = 393,
  BoolBinary_eq = 394,
  BoolBinary_ne = 395,
  BoolBinary_gt = 396,
  BoolBinary_ge = 397,
  BoolBinary_lt = 398,
  BoolBinary_le = 399,
  BoolBinary_Equal = 400,
  BoolBinary_DEqual = 401,
  BoolBinary_NEqual = 402,
  ARRAY_SIZE = 403,
  };
};

BigStr* Id_str(int tag, bool dot = true);

typedef uint16_t Id_t;

enum class Kind {
  Word = 1,
  Arith = 2,
  Eof = 3,
  Undefined = 4,
  Unknown = 5,
  Eol = 6,
  Ignored = 7,
  WS = 8,
  Lit = 9,
  Backtick = 10,
  History = 11,
  Op = 12,
  Expr = 13,
  Char = 14,
  BashRegex = 15,
  Eggex = 16,
  Redir = 17,
  Left = 18,
  Right = 19,
  ExtGlob = 20,
  VSub = 21,
  VTest = 22,
  VOp0 = 23,
  VOp1 = 24,
  VOpYsh = 25,
  VOp2 = 26,
  VOp3 = 27,
  Node = 28,
  KW = 29,
  ControlFlow = 30,
  LookAhead = 31,
  Glob = 32,
  Format = 33,
  PS = 34,
  Range = 35,
  J8 = 36,
  BoolUnary = 37,
  BoolBinary = 38,
};
typedef Kind Kind_t;

BigStr* Kind_str(Kind tag, bool dot = true);


}  // namespace id_kind_asdl

#endif  // ID_KIND_ASDL_H
